<?php
      $myhtmltitle= "tomveatch.com / tg / PH";
      $mytitle    = "Pratyabhijna HRdayam";
      $mysubtitle = "The Heart of Recognition";
      $mypathhome = "../../"; // from . to /var/www/tomveatch.com/
      $mylbarfile = "";
      $myrbarfile = "";
      $homehost   = "https://tomveatch.com";
      $myscriptsrc = "<style> .tg td { border: black 1px solid;   } 
      		              table.tg { border-collapse: collapse; border: black 3px solid;  } 
		     </style>\n";
      include "/var/www/shared/mytop.php";
?>

<CENTER>
<B><U>Rant:</U></B> Why depend on <A HREF="rant.php">commentators and evocation authors</A>, when you can directly access the originals?<P>

<B><U>Introduction:</U></B>

Following is my Final Project for UW Sanskrit 103, Spring 2024, with Buddhist Studies Prof. Joe Marino.<P>

Below are some (1-3, 10-13) of the famous 20 verses by
Kshemar&amacr;ja summarizing the philosophical tradition of Kashmiri
Shaivism,<BR> including enough translation detail to support you to
directly learn to understand the actual Sanskrit as used here in its
original form.<P>

<H2>Resources</H2></CENTER>

<B><U><A HREF="https://TomVeatch.com/tg/PH/key.php">Key</A></U></B><BR>
(abbreviations, symbols, grammatical terms used below)<P>

<B><U><A HREF="https://TomVeatch.com/gg/GuruGita/Devanagari.php">Script learning tool</A></U></B><BR>
(click through and click "Switch" to learn and practice)<P>

<B><U>Selected Dictionary Entries: </U></B><BR>
| 
<A HREF="https://tomveatch.com/tg/PH/dict.php#siddhi">siddhi</A> |
<A HREF="https://tomveatch.com/tg/PH/dict.php#svatantrA">svatantrA</A> |
<A HREF="https://tomveatch.com/tg/PH/dict.php#-A">-A</A> |
<A HREF="https://tomveatch.com/tg/PH/dict.php#A-">A-</A> |
<A HREF="https://tomveatch.com/tg/PH/dict.php#-At">-At</A> |
<A HREF="https://tomveatch.com/tg/PH/dict.php#cit">cit</A> |
<A HREF="https://tomveatch.com/tg/PH/dict.php#anurUpa">anurUpa</A> |
<A HREF="https://tomveatch.com/tg/PH/dict.php#AbhAsana">AbhAsana</A> |
<A HREF="https://tomveatch.com/tg/PH/dict.php#vimarshana">vimarshana</A> |
<A HREF="https://tomveatch.com/tg/PH/dict.php#vilApana">vilApana</A> |
<A HREF="https://tomveatch.com/tg/PH/dict.php#vya">vya</A> |
<A HREF="https://tomveatch.com/tg/PH/dict.php#mohitatA">mohitatA</A> |
<A HREF="https://tomveatch.com/tg/PH/dict.php#sakti">sakti</A> |
<A HREF="https://tomveatch.com/tg/PH/dict.php#samAritvam">samAritvam</A> |
<A HREF="https://tomveatch.com/tg/PH/dict.php#adhyArohAt">ArohAt</A> |<P>

<CENTER><H2>Verses</H2></CENTER>

<?php include "/var/www/tomveatch.com/tg/tglib.php";

/*
P = Pratyabhijnahrdayam = TG() =
 {
   N 20 verses in Nagari, nodes = spaces|punct
   R 20 verses transliterated roman, nodes = spaces|punct
   I 20 verses with sandhi unwound to show inflectional morphemes & boundaries delimited by -
   D 20 verses with derivational morphemes delimited by +
   C 20 verses with grammatical morpheme labels/codings
   M 20 verses with stem-wise translations
   P 20 verses with phrasal translations
   F 20 verses with full-verse translations
   X 20 verses with interpretive commentary
 }

unfortunately JSON and PHP initialization of frag structures does not come out the same.
In JSON:
  GuruGitaVerses is an {} object with a bunch of key-value pairs, each key is a
    labelled "index" key, each value is an array of 1 or 2 fragments.
      array of 1 or 2 lines each a fragment
        frag here is an object of "R" etc keys and text string values.

In PHP:
  array of 1-20 frags
    frag has ...

*/

$fr[1] = array(
"N" => ".N0 Nagari: .N4 चिति: स्वतन्त्रा विश्वसिद्धिहेतु: .N$",
"R" => ".N0 Roman: .N4 <A HREF=\"https://tomveatch.com/tg/PH/dict.php#cit\">citiH</A> .N1 <A HREF=\"https://tomveatch.com/tg/PH/dict.php#svatantrA\">svatantrA </A> .N2 viSvasiddhihetuH .N$",
"I" => ".N0 Inflection: .N4 citi .I1 -h .N1 svatantra^ .I2 <A HREF=\"https://tomveatch.com/tg/PH/dict.php#-A\">-A</A> .N2 viSva .I3 <A HREF=\"https://tomveatch.com/tg/PH/dict.php#siddhi\">siddhi</A> .I4 hetu- .I5 -H .I6  [asti] .N$",
"D" => ".N0 Derivation: .N4 citi .I1 -h .N1 sva .D1 tan .D2 tra^ .I2 -A .N2 viS .D3 va .D4 -asya^^^^ .I3 saadh^^^^ .D5 -idh .D6 -ta^ .D7 -i .D8 [-eh] .I4 \" .I5 \" .I6 \" .N$",
"C" => ".N0 Encodings:  .N4 \" .I1 M-i]sg/nom(v1) .N1 refl .D1 stretch .D2 means-of .I2 F-A]sg/nom(v1) .N2 pervade .D3 ]N/M .D4 M-a]sg/gen(v6) .I3 go straight .D5 w of &Sqrt; .D6 PaP .D7 N .D8 [sg/gen(v6)] .I4 cause .I5 ]N M-u/sg/nom(v1) .I6 [be] .N$",
"M" => ".N0 Stems: .N4 consciousness/M/sg/v1 .N1 self-will/F-ih/sg/v1 .N2 all,world/N/sg/gen 6TP .I3 attainment,performance/M/sg/gen 6TP .I4 cause ]N .I6 is .N$",
"P" => ".N0 Phrases .N4 consciousness, freedom .N2 of the performance of the universe .I4 is the cause .N$",
"F" => ".N0 Translation: .N4 consciousness, which is freedom, is the cause of the performance of everything .N$",
"X" => ".N0 Evocation: .N4 The world is a performance, and the freedom that is consciousness is its cause. .N$"
);

$fr[2] = array(
"N" => ".N0 स्वेच्छया  स्वभित्तौ  विस्वमुन्मीलयति .N$",
"R" => ".N0 svecchayA .N1 svabhittau .N2 viSvamunmIlayati .N$",
"I" => ".N0 sveccha^        .I1 -ayA .N1 svabhitti^ .I2 -au .N2 viSva^ .I3 -am .I4 unmIlaya^ .I5 -ati .N$",
"D" => ".N0 sva+ .D1 iccha^ .I1 \"     .N1 sva  .D3 bhid  .D4 -ti^ .I2 \"    .N2 viS     .D5 -va^ .I3 \"   .I4 ud .D6 mIl          .D7 aya^ .I5 \" .N$",
"C" => ".N0 refl .D1 desire .I1 F-a/sg/v3 .N1 refl .D3 split .D4 PPP .I2 F-ih/sg/loc(v7) .N2 pervade .D5 ]N .I3 M-a/sg/v2 .I4 up .D6 close (eyes) .D7 caus .I5 3p-sg-indic .N$",
"M" => ".N0 by self-will               .N1 own  .D3 piece,wall .I2 at,on      .N2 world,all                   .I4 causes to open eyes .N$",
"P" => ".N0 by its own will            .N1 on its own wall/screen    .N2 the world                   .I4 shows, displays .N$",
"F" => ".N0 (it) displays the world on its own screen by its own will .N$",
"X" => ".N0 By its desire [Consciousness] causes the universe to be seen on its internal screen. .N$"
);

$fr[3] = array(
"N" => ".N0 तन्नान अनुरूपग्राह्यग्राहकभेदात्     .N$",
"R" => ".N0 tannAna .N1 anurUpagrAhyagrAhakabhedAt .N$",
"I" => ".N0 tat(neut) .I1 nAna .N1 <A HREF=\"https://tomveatch.com/tg/PH/dict.php#anurUpa\">anurUpa</A> .I2 grAhya             .I3 grAhaka           .D5   ]     .I4 bheda^                      .I5 -At    .I6 [bhavati] .N$",
"D" => ".N0 \"  .I1   \"   .N1 anu .D1 rUpa     .I2 gRh .D2 +vr -ya         .I3 gRh .D3 +vr .D4 -aka .D5 dvandva .I4 bhid .D6 &Sqrt; +gu -a .I5 M-a/sg/abl(v5) .I6 be-0      .N$",
"C" => ".N0 that .I1 various .N1 after- .D1 form .I2 grasp .D2 -PPP         .I3 grasp .D3 ]agent N   .D5 and, between .I4 split .D6   ]N M   .I5 from            .I6 [is]      .N$",
"M" => ".N0 \" .I1 various things .N1 suitable,conformable,corresponding .I2 the grasped,held,beheld .I3 the beholder .D5 between .I4 from the difference .I6 becomes,arises      .N$",
"P" => ".N0 That .I1 anything .N1 corresponding .I2 the beheld .I3 and the beholder .D5 from the separation between .I6 arises .N$",
"F" => ".N0 That becomes all kinds of things, out of the division between the corresponding beholder and beheld .N$",
"X" => ".N0 That becomes everything by dividing itself into beholder and beheld each corresponding to the other. .N$"
);

$fr[10] = array(
"N" => ".N0 तथापि तद्वत्पञ्चक्रित्यानि करोति .N$",
"R" => ".N0 tathA'pi tadvat panca krityAni karoti .N$",
"I" => ".N0 tathA           .I1 api       .I2 tat  .I3 vat  .I4 pAnc .I5 kritya^ .I6 -Ani .I7 karo .I8 -ti .N$",
"D" => ".N0 ta^- .D1 -athaa .I1 \"        .I2 \"   .I3 \"   .I4 \"   .I5 kR .D2 past-passive .D3 -ya]abstract N Ne .I6 Ne-a pl/acc(v2) .I7 kR .D4 +gu -o (ga8) .I8 present 3p/sg (P) .N$",
"C" => ".N0 that .D1 manner .I1 also,even .I2 that .I3 like .I4 five .I5 what is done        .I6 \" .I7 do .I8 \" .N$",
"M" => ".N0 thus, so        .I1 even      .I2 That,Shiva .I3 \" .I4 \" .I5 actions             .I6 pl .I7 does .N$",
"P" => ".N0 even thus (while being a sufferer) .I2 like That, .I4 [one] does the five actions  .N$",
"F" => ".N0 despite suffering, one carries out the five actions like Shiva.  .N$",
"X" => ".N0 Even we sufferers carry out the divine five-fold action of Shiva within ourselves. .N$"
);

$fr[11] = array(
"N" => ".N0 आभासनरक्तिविमर्शनबीजावस्थापनविलापनतस्तानि .N$",
"R" => ".N0 <A HREF=\"https://tomveatch.com/tg/PH/dict.php#AbhAsana\">AbhAsana </A> .R1 rakti .R2 <A HREF=\"https://tomveatch.com/tg/PH/dict.php#vimarshana\">vimarSana</A> .R3 bIjAvasthApana .R4 <A HREF=\"https://tomveatch.com/tg/PH/dict.php#vilApanatas\">vilApanatas</A>tAni .N$",
"I" => ".N0 AbhAsa^ .I1 -ana .R1 rakta^ .I2 -i .R2 vimarSa^          .I3 -ana .R3 bIja .I4 avasthApa^             .I5 -ana .R4 vilAp               .I6 -ana   .I7 -tah .I8 tAni .N$",
"D" => ".N0 A- .D1 bhA .I1 -ana .R1 blood  .I2 -y .R2 vi- .D2 marSa^ .I3 \"   .R3 \"   .I4 ava- .D3 sthA .D4 -pa^ .I5 -ana .R4 vi- .D5 lap .D6 +vr .I6 \"     .I7 -tas .I8 \" .N$",
"C" => ".N0 near, towards .D1 shine .I1 -N  .R1 (taste of) blood .R2 against .D2 patient,forgiving .I3 ]N .R3 seed .I4 down .D3 stay .D4 passive .I5 ]N .R4 against .D5 lament,wail .D6 caus .I6 ]N .I7 v5 .I8 that pr/ne/pl .N$",
"M" => ".N0 shining upon .R1 relishing like the taste of blood .R2 irritation,displeasure .R3 seed .I4 what was stayed down .R4 grief, weeping .I6 those .N$",
"P" => ".N0 appearance .R1 relishing .R2 irritation .R3 the settling of the seed .R4 grief .I6 those .N$",
"F" => ".N0 (The five fold actions are) those: manifestation, relishing, irritation, the settling of the seed, grief .N$",
"X" => ".N0 The fivefold action of Shiva namely creation, sustenance, destruction, concealment and grace, can be reinterpreted as shining manifestation, relishing like the taste of blood, irritation like having to let go of a thing, a settling in the emotional center, and (?going beyond?) grief. .N$"
);

$fr[12] = array(
"N" => ".N0 तदपरिज्ञाने   स्वशक्तिभिरव्यमोहितता संसारित्वम .N$",
"R" => ".N0 tad .R1 aparijnAne .R2 svaSaktibhirvya<A HREF=\"https://tomveatch.com/tg/PH/dict.php#mohitatA\">mohitatA</A> .R3 <A HREF=\"https://tomveatch.com/tg/PH/dict.php#saMsAritvam\">saMsAritvam</A> .N$",
"I" => ".N0 \" .R1 a .I1 pari .I2 jnAna^ .I3 -e .R2 sva .I4 <A HREF=\"https://tomveatch.com/tg/PH/dict.php#shakti\">Sakti</A>bhih .I5 <A HREF=\"https://tomveatch.com/tg/PH/dict.php#vya\">vya</A> .I6 moha^ .I7 -ita .I8 -tA .R3 saMsAritva^ .I9 -am .I10 [asti] .N$",
"D" => ".N0 \" .R1 \" .I1 \" .I2 jnA(9P) .D1 -ana^ .I3 -e .R2 \" .I4 Sak .D2 -ti^ .D3 -ibhih .I5 vya [-ena] .I6 \" .I7 \" .I8 \" .R3 sam .D4 sR .D5 &Sqrt; +vr .D6 -i .D7 -tva .I9 \" .I10 \" .N$",
"C" => ".N0 that .R1 around .I2 knowing .I3 loc(v7) .R2 refl .I4 be able to .D2 -N .D3 -pl/instr(v3) .I5 coverer[-instr] .I6 delude .I7 PaP .I8 ]N F Abs .R3 together .D4 flow .D5 caus. .D6 ]N .D7 ]N Ne abs .I9 -Ne]sg/acc(v2)  .I10 is .N$",
"M" => ".N0 that .R1 in the location of knowing-around .R2 one's own .I4 power .D3 -s, by means of .I5 \" .I6 deluded .I8 \" .R3 transmigrate .D6 one who is/does .D7 the state of .I9 \" .I10 \" .N$",
"P" => ".N0 where not knowing that (the above) .R2 by means of a coverer using one's own powers .I6 delusion .R3 is the state of being an ignorant eternal sufferer .N$",
"F" => ".N0 Failing to know that [and] covered and deluded by one's own powers, is the nature of suffering .N$",
"X" => ".N0 Failing to know the central point, knowing around it, namely that we carry out these 5 powers ourselves,<BR> our state of ignorant eternal suffering is simply a delusion in which by my own powers I am the coverer. .N$"
);

$fr[13] = array(
"N" => ".N0 तत्परिज्ञाने .N1  चित्तमेव .N2  अन्तर्मुखिभावेन .N3    चेतनपदाध्यारोहाच्चितिः  .N$",
"R" => ".N0 tatparijnAne                       .N1 cittameva              .N2 antarmukhibhAvena                          .N3 cetanapadAdhy<A HREF=\"https://tomveatch.com/tg/PH/dict.php#ArohAt\">ArohAc</A>citih .N$",
"I" => ".N0 tat .I1 parijnAna^ .I2 -e          .N1 citta^ .I3 -am .I4 eva .N2 antar .I5 mukha^ .I6 -i .I7 bhAva^ .I8 -ena .N3 <A HREF=\"https://tomveatch.com/tg/PH/dict.php#cetana\">cetana</A> .I9 pada .I10 adhi .I11 Aroha^ .I12 <A HREF=\"https://tomveatch.com/tg/PH/dict.php#-At\">-At</A> .I13 <A HREF=\"https://tomveatch.com/tg/PH/dict.php#cit\">citi</A> .I14 -H .N$",
"D" => ".N0 \" .I1 pari .D1 jnA^ .D2 -ana .I2 \" .N1 cit .D3 -ta .I3 \" .I4 \" .N2 \" .I5 \" .I6 \" .I7 bhU .D4 &Sqrt; +vr -a]N .I8 \" .N3 cit .D5 &Sqrt; +gu .D6 -ana .I9 \" .I10 \" .I11 <A HREF=\"https://tomveatch.com/tg/PH/dict.php#A-\">A-</A> .D7 ruh .D8 +vr -a .I12 \" .I13 \" .I14 \" .N$",
"C" => ".N0 that .I1 around .D1 know .D2 ]N .I2 loc(v7) .N1 know .D3 PaP .I3 acc(v2) .I4 only .N2 inward .I5 face .I6 Adj .I7 becoming .I8 instr(v3) .N3 know .D5 ]Adj .D6 ]N Ne agent .I9 state .I10 over .I11 back .D7 rise,climb .D8 ]N .I12 abl(v5) .I13 consciousness .I14 M-ih sg/nom(v1) .N$",
"P" => ".N0 where knowing all that .N1 the known .I4 even .N2 inward-facing .I7 attitude .I8 instr(v3) .N3 the state of the knower .I10 from rising back up .I13 consciousness [is].N$",
"F" => ".N0 [but] when knowing all that .N1 even that which is known .N2 by means of an inward-facing attitude .N3 from the state of the knower rising up again .I13 is consciousness .N$",
"X" => ".N0 But when knowing all that, with an inward-facing attitude even that which is known, from the rising up again of the state of the knower, becomes [pure] consciousness. .N$"
);

for ($i=1; $i<=20; $i++) {
  if (isset($fr[$i])) {
    echo "<B>Verse $i</B><BR>\n";
    echo frag2HtmlTable($fr[$i], array("N", "R", "I", "D", "C", "M", "P", "F", "X"));
    echo "&nbsp;<P>\n";
  } 
}
?>

<!--
The above was written using the following Sanskrit and software resources:<P>

<UL>
<LI>
DevavANIpraveSikA, An Introduction to the Sanskrit Language, by Robert
P. Goldman and Sally J. Sutherland Goldman. 2011.<P>

<LI> A Sanskrit-English Dictionary, by Monier Monier-Williams, as accessed on the internet at <A HREF="https://gandhari.org">gandhari.org"</A>.<P>

<LI> <A HREF="https://tomveatch.com/tg">Translation Graphs</A> multilinear text formatting software, by Tom Veatch.<P>
</UL>

<B>Future Work:</B><P>

I hope to make display of dictionary selections and access to script
tutorials available soon within this and future
Translation-Graph-enabled pages.  <!-- Write and encourage me; I appreciate it and respond. --><P>

<?php
      $myuri  = "tg/PH/index.php";
      $myfrom = "bottom";
      $mycopyrightyears = "2000 - 2024";
      $mychangedates = "Created: May/June 2024";
      $feedbox_prompt = "Comments, corrections, suggestions?";
      include "/var/www/shared/mybot.php";
 ?>
